;WiTS portable auto-create/Run
#NoTrayIcon
#include <Array.au3>

Global $AppName,$AppExe,$AppParam,$tmpReg,$HostReg,$PortReg,$SetupURL,$Extractor,$ExtractParam,$MoveFrom[1],$MoveTo[1],$CleanUp[1],$Registry[1]
$AppDir = @ScriptDir&'\App\'
$SettingsDir = @ScriptDir&'\Data\Settings\'
$BinDir = @ScriptDir&'\Data\bin\'
$SetupDir = @ScriptDir&'\Data\Install\'
$tmpReg = $SettingsDir&'tmpReg.reg'
$HostReg = $SettingsDir&'HostReg.reg'
$PortReg = $SettingsDir&'PortableReg.reg'

;Configurable settings
$AppName = 'Crossloop'
$AppExe = 'CrossLoopConnect.exe'
$AppParam = '-ap=crossloop -port=5910 -udp=www.CrossLoop.com -webserver=server.crossloop.com -webservice=www.crossloop.com -startup=server'
$SetupURL = 'http://download.crossloop.com/crossloopsetup.exe'
$SetupExe = 'setup.exe'

;Before all else, do crash-recovery
If FileExists($HostReg) Then
	$crashdlg = MsgBox(19,$AppName&' Portable',$AppName&' did not close properly the previous exit, would you like perform crash-cleanup?')
	If $crashdlg = 6 Then
		FileDelete($PortReg)
		ReplaceReg($PortReg, $HostReg)
		FileDelete($HostReg)
		MsgBox(48, $AppName&' Portable','Crash-cleanup was successful, launching '&$AppName&' now.')
	ElseIf $crashdlg = 7 Then
		$crashdlg2 = MsgBox(4,$AppName&' Portable',$AppName&' are you sure you want to delete the crash file? This will irreversibly commit any changes to the registry that were made last time '&$AppName&' was launched.')
		If $crashdlg2 = 6 Then
			FileDelete($HostReg)
		Else
			MsgBox(48, $AppName&' Portable','Crash file was not deleted, closing now.')
			Exit
		EndIf
	Else
		MsgBox(48, $AppName&' Portable','Crash file was not deleted, closing now.')
		Exit
	EndIf
EndIf

;Extracting commands, this must be rewritten specificly for the program you're portabilizing
Func Extract()
	RunWait($BinDir&'\innounp.exe -x setup.exe',$SetupDir,@SW_HIDE)
EndFunc

;Once setup has been extracted, move these files
_ArrayAdd($MoveFrom, '{app}\*')
_ArrayAdd($MoveTo, '')

;After copying files, remove these unnecessary files
_ArrayAdd($CleanUp, 'Uninstall.ico')

;These are registry sections which will be kept portable
_ArrayAdd($Registry, 'HKEY_CURRENT_USER\Software\CrossLoop')

;Array management
$MoveFrom[0]=UBound($MoveFrom)-1
$MoveTo[0]=UBound($MoveTo)-1
$CleanUp[0]=UBound($CleanUp)-1
$Registry[0]=UBound($Registry)-1

;This can be removed from the final version 
If $MoveFrom[0]<>$MoveTo[0] Then
	MsgBox(48, $AppName&' Portable', '$MoveFrom count is not equal to $MoveTo. This script must be revised before it can be executed')
	Exit
EndIf

;Create portable environment if it does not exist
If Not FileExists($AppDir&$AppExe) Then
	$Install = MsgBox(1,$AppName&' Portable',$AppName&' files are not present in /App folder'&@CRLF&@CRLF&'Click OK to automaticly download/extract the required files or Cancel to exit this program.')
	If $Install = 1 Then
		DirCreate($SetupDir)
		GetInstaller()
		ProgressSet(50, '50% Done!', 'Extracting downloaded setup file')
		Extract()
		ProgressSet(75, '75% Done!', 'Moving files')
		MoveFiles()
		ProgressSet(95, '95% Done!', 'Finishing up')
		Clean()
		ProgressSet(100, '100% Done!', 'Starting '&$AppName)
		ProgressOff()
	Else
		Exit
	EndIf
EndIf

;Run registry backup/substitution then execute program
ReplaceReg($HostReg, $PortReg)
If $AppParam='' Then
	$PID = Run($AppDir&$AppExe&' '&$CmdLineRaw)
Else
	$PID = Run($AppDir&$AppExe&' '&$AppParam)
EndIf
While ProcessExists($PID)
	Sleep(1500)
WEnd

;Reset registry entries and exit
FileDelete($PortReg)
ReplaceReg($PortReg, $HostReg)
FileDelete($HostReg)
Exit

Func GetInstaller()
	$UpdateSize = InetGetSize($SetupURL)
	InetGet($SetupURL,$SetupDir&$SetupExe,1,1)
	ProgressOn('Setting up '&$AppName&' Portable', 'Waiting for download to start...')

	;Update the progress bar until it's done downloading
	While @InetGetActive
		$Progress = Int(@InetGetBytesRead/$UpdateSize*50)
		ProgressSet($Progress, $Progress&'% Done!', 'Downloading '&$AppName&' Setup')
		Sleep(500)
	WEnd
EndFunc

Func ReplaceReg($Replace, $With)
	$AllReg = ''
	For $i = 1 to $Registry[0]
		RunWait('REGEDIT /E /S "'&$tmpReg&'" "'&$Registry[$i]&'"')
		RegDelete($Registry[$i])
		$tmp = FileRead($tmpReg)
		FileDelete($tmpReg)
		$tmp = StringSplit($tmp, @LF)
		For $j = 3 to $tmp[0]
			$AllReg = $AllReg & $tmp[$j]
		Next
	Next
	FileWrite($Replace, "Windows Registry Editor Version 5.00"&@CRLF&@CRLF&$AllReg)
	If FileExists($With) Then RunWait('REGEDIT /S "'&$With&'"')
EndFunc

Func MoveFiles()
	For $i = 1 to $MoveFrom[0]
		$isdir = FileGetAttrib($SetupDir&$MoveFrom[$i])
		If StringInStr($isdir, "D") And StringRight($SetupDir&$MoveFrom[$i],1)<>'*' Then
			DirMove($SetupDir&$MoveFrom[$i],$AppDir&$MoveTo[$i],1)
		Else
			FileMove($SetupDir&$MoveFrom[$i],$AppDir&$MoveTo[$i],9)
		EndIf
		$Progress = Int(75+((20/$MoveFrom[0])*$i))
		ProgressSet($Progress, $Progress&'% Done!', 'Moving files')
	Next
EndFunc

Func Clean()
	For $i = 1 to $CleanUp[0]
		FileDelete($AppDir&$CleanUp[$i])
		$Progress = Int(75+((5/$CleanUp[0])*$i))
		ProgressSet($Progress, $Progress&'% Done!', 'Finishing up')
	Next
	DirRemove($SetupDir,1)
	DirRemove($BinDir,1)
EndFunc